﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.ServiceProcess;
using System.Text;
using BMS.Utils;

namespace BMS.ServiceHost
{
    static class Program
    {
        private static BmsLogger logger = new BmsLogger("Program:");
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        static void Main()
        {
            AppDomain.CurrentDomain.UnhandledException += OnAppDomainUnhandledException;
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                var ServicesToRun = new ServiceBase[]
			{ 
				new BMSService() 
			};
                ServiceBase.Run(ServicesToRun);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        private static void OnAppDomainUnhandledException(object sender, UnhandledExceptionEventArgs e)
        {
            logger.LogFormat(
                BmsLogger.Level.Error,
                "Unhandled exception occurred{0}.\r\n{1}",
                e.IsTerminating ? " causing termination" : string.Empty,
                e.ExceptionObject);
        }
    }
}
